#include "stdafx.h"
#include "Callbacks.h"

#define BITMAP_ID 0x4D42

double xRot = 0.0;
double yRot = 0.0;

double r1, r2, r3;

BITMAPINFOHEADER	bitmapInfoHeader;	
unsigned char*		bitmapData;			
unsigned int		texture[2];			

unsigned char *LoadBitmapFile(const char *filename, BITMAPINFOHEADER *bitmapInfoHeader)
{
	FILE *filePtr;							// wskanik pozycji pliku
	BITMAPFILEHEADER	bitmapFileHeader;		// nagwek pliku
	unsigned char		*bitmapImage;			// dane obrazu
	int					imageIdx = 0;		// licznik pikseli
	unsigned char		tempRGB;				// zmienna zamiany skadowych
	errno_t err;

												// otwiera plik w trybie "read binary"
	err=fopen_s(&filePtr, filename, "rb");
	if (filePtr == NULL)
		return NULL;

	// wczytuje nagwek pliku
	fread(&bitmapFileHeader, sizeof(BITMAPFILEHEADER), 1, filePtr);

	// sprawdza, czy jest to plik formatu BMP
	if (bitmapFileHeader.bfType != BITMAP_ID)
	{
		fclose(filePtr);
		return NULL;
	}

	// wczytuje nagwek obrazu
	fread(bitmapInfoHeader, sizeof(BITMAPINFOHEADER), 1, filePtr);

	// ustawia wskanik pozycji pliku na pocztku danych obrazu
	fseek(filePtr, bitmapFileHeader.bfOffBits, SEEK_SET);

	// przydziela pami buforowi obrazu
	bitmapImage = (unsigned char*)malloc(bitmapInfoHeader->biSizeImage);

	// sprawdza, czy udao si przydzieli pami
	if (!bitmapImage)
	{
		free(bitmapImage);
		fclose(filePtr);
		return NULL;
	}

	// wczytuje dane obrazu
	fread(bitmapImage, 1, bitmapInfoHeader->biSizeImage, filePtr);

	// sprawdza, czy dane zostay wczytane
	if (bitmapImage == NULL)
	{
		fclose(filePtr);
		return NULL;
	}

	// zamienia miejscami skadowe R i B 
	for (imageIdx = 0; imageIdx < bitmapInfoHeader->biSizeImage; imageIdx += 3)
	{
		tempRGB = bitmapImage[imageIdx];
		bitmapImage[imageIdx] = bitmapImage[imageIdx + 2];
		bitmapImage[imageIdx + 2] = tempRGB;
	}

	// zamyka plik i zwraca wskanik bufora zawierajcego wczytany obraz
	fclose(filePtr);
	return bitmapImage;
}
// Reduces a normal vector specified as a set of three coordinates,
// to a unit normal vector of length one.
void ReduceToUnit(float vector[3])
{
	float length;

	// Calculate the length of the vector		
	length = (float)sqrt((vector[0] * vector[0]) +
		(vector[1] * vector[1]) +
		(vector[2] * vector[2]));

	// Keep the program from blowing up by providing an exceptable
	// value for vectors that may calculated too close to zero.
	if (length == 0.0f)
		length = 1.0f;

	// Dividing each element by the length will result in a
	// unit normal vector.
	vector[0] /= length;
	vector[1] /= length;
	vector[2] /= length;
}


// Points p1, p2, & p3 specified in counter clock-wise order
void calcNormal(float v[3][3], float out[3])
{
	float v1[3], v2[3];
	static const int x = 0;
	static const int y = 1;
	static const int z = 2;

	// Calculate two vectors from the three points
	v1[x] = v[0][x] - v[1][x];
	v1[y] = v[0][y] - v[1][y];
	v1[z] = v[0][z] - v[1][z];

	v2[x] = v[1][x] - v[2][x];
	v2[y] = v[1][y] - v[2][y];
	v2[z] = v[1][z] - v[2][z];

	// Take the cross product of the two vectors to get
	// the normal vector which will be stored in out
	out[x] = v1[y] * v2[z] - v1[z] * v2[y];
	out[y] = v1[z] * v2[x] - v1[x] * v2[z];
	out[z] = v1[x] * v2[y] - v1[y] * v2[x];

	// Normalize the vector (shorten length to one)
	ReduceToUnit(out);
}


/* Keyboard callback function */
void keyboard(unsigned char key, int x, int y)
{
  switch (key)
  {
    /* Exit on escape key press */
    case '\x1B':
    {
      exit(EXIT_SUCCESS);
      break;
    }
	case  'd':
	{
		yRot += 5.0;
		//glRotated(5, 0, 1, 0);
		glutPostRedisplay();
		break;
	}
	case  'a':
	{
		yRot -= 5.0;
		//glRotated(-5, 0, 1, 0);
		glutPostRedisplay();
		break;
	}
	case  'w':
	{
		xRot -= 5.0;
		//glRotated(-5, 1, 0, 0);
		glutPostRedisplay();
		break;
	}
	case  's':
	{
		xRot += 5.0;
		//glRotated(5, 1, 0, 0);
		glutPostRedisplay();
		break;
	}
	case  '1':
	{
		r1 += 5.0;
		glutPostRedisplay();
		break;
	}
	case  '2':
	{
		r1 -= 5.0;
		glutPostRedisplay();
		break;
	}
	case  '3':
	{
		r2 += 5.0;
		glutPostRedisplay();
		break;
	}
	case  '4':
	{
		r2 -= 5.0;
		glutPostRedisplay();
		break;
	}
	case  '5':
	{
		r3 += 5.0;
		glutPostRedisplay();
		break;
	}
	case  '6':
	{
		r3 -= 5.0;
		glutPostRedisplay();
		break;
	}
  }
}



void idle(void)
{
	//r1 += 0.05;
	glutPostRedisplay();
}

void myReshape(int w, int h)
{
	//int w, h;
	//w = glutGet(GLUT_WINDOW_WIDTH);
	//h = glutGet(GLUT_WINDOW_HEIGHT);
	glViewport(0, 0, w, h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	if (w <= h)
		glOrtho(-100.0, 100.0, -100.0 * (GLfloat)h / (GLfloat)w,
			100.0 * (GLfloat)h / (GLfloat)w, -100.0, 100.0);
	else
		glOrtho(-100.0*(GLfloat)w / (GLfloat)h,
			100.0*(GLfloat)w / (GLfloat)h, -100.0, 100.0, -100.0, 100.0);
}




/* Display callback function */
void display()
{
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glRotated(xRot, 1, 0, 0);
  glRotated(yRot, 0, 1, 0);
  glClearColor(1.0, 1.0, 1.0,1.0);
  glClearDepth(1.0);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glPolygonMode(GL_BACK, GL_LINE);
  //glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
  my_rectangle();
  //my_cube();
  //my_cylinder(0.4, 0.8);
  //my_arm(0.20, 0.15, 0.05, 0.4);
  //my_robot(r1,r2,r3);
  //my_two_robots();
  //my_normal_calculation_example();
  //my_box();
  glutSwapBuffers();
  glFlush();
}

void myInit(void)
{
	// Light values and coordinates
	//GLfloat  ambientLight[] = { 0.3f, 0.3f, 0.3f, 1.0f };
	//GLfloat  diffuseLight[] = { 0.7f, 0.7f, 0.7f, 1.0f };
	//GLfloat  specular[] = { 1.0f, 1.0f, 1.0f, 1.0f };
	//GLfloat	 lightPos[] = { 0.0f, 15.0f, 15.0f, 1.0f };
	//GLfloat  specref[] = { 1.0f, 1.0f, 1.0f, 1.0f };


	glEnable(GL_DEPTH_TEST);	// Hidden surface removal
	glFrontFace(GL_CCW);		// Counter clock-wise polygons face out
	//glEnable(GL_CULL_FACE);		// Do not calculate inside of jet

								// Enable lighting
	//glEnable(GL_LIGHTING);

	// Setup and enable light 0
	//glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);
	//glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuseLight);
	//glLightfv(GL_LIGHT0, GL_SPECULAR, specular);
	//glLightfv(GL_LIGHT0, GL_POSITION, lightPos);
	//glEnable(GL_LIGHT0);

	// Enable color tracking
	//glEnable(GL_COLOR_MATERIAL);

	// Set Material properties to follow glColor values
	//glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);

	// All materials hereafter have full specular reflectivity
	// with a high shine
	//glMaterialfv(GL_FRONT, GL_SPECULAR, specref);
	//glMateriali(GL_FRONT, GL_SHININESS, 128);

	glGenTextures(2, &texture[0]);                  
	bitmapData = LoadBitmapFile("Bitmaps\\checker.bmp", &bitmapInfoHeader);

	glBindTexture(GL_TEXTURE_2D, texture[0]);       // aktywuje obiekt tekstury

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

	// tworzy obraz tekstury
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, bitmapInfoHeader.biWidth,
		bitmapInfoHeader.biHeight, 0, GL_RGB, GL_UNSIGNED_BYTE, bitmapData);

	if (bitmapData)
		free(bitmapData);

	// aduje drugi obraz tekstury:
	bitmapData = LoadBitmapFile("Bitmaps\\crate.bmp", &bitmapInfoHeader);
	glBindTexture(GL_TEXTURE_2D, texture[1]);       // aktywuje obiekt tekstury

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

	// tworzy obraz tekstury
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, bitmapInfoHeader.biWidth,
		bitmapInfoHeader.biHeight, 0, GL_RGB, GL_UNSIGNED_BYTE, bitmapData);

	if (bitmapData)
		free(bitmapData);

	// ustalenie sposobu mieszania tekstury z tem
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

}

void my_rectangle(void)
{
	/* Display a red square */
	glColor3d(0.5, 0.1, 0.0);
	glBegin(GL_QUADS);
	glVertex2f(-20.0f, -20.0f);
	glVertex2f(20.0f, -20.0f);
	glVertex2f(20.0f, 20.0f);
	glVertex2f(-20.0f, 20.0f);
	glEnd();
}
